[Grunt homepage](https://github.com/cowboy/grunt)

# Documentation table of contents

## Getting started <a name="getting-started" href="#getting-started" title="Link to this section">⚑</a>

* [Getting started](getting_started.md) - A guide to configuring grunt for your project.
* [Example gruntfiles](example_gruntfiles.md) - A few samples, to help you get started.
* [The grunt API](api.md) - Complete API documentation here!
* [FAQ](faq.md) - Frequently asked questions, along with their answers.
* [Exit codes](exit_codes.md) - A list of all built-in grunt exit codes.

## Built-in tasks <a name="built-in-tasks" href="#built-in-tasks" title="Link to this section">⚑</a>

* [concat](task_concat.md) - Concatenate files.
* [init](task_init.md) - Generate project scaffolding from a predefined template.
* [lint](task_lint.md) - Validate files with [JSHint][jshint].
* [min](task_min.md) - Minify files with [UglifyJS][uglify].
* [qunit](task_qunit.md) - Run [QUnit][qunit] unit tests in a headless [PhantomJS][phantom] instance.
* [server](task_server.md) - Start a static web server.
* _(more documentation coming soon)_

<!--
* [test](task_test.md) - Run unit tests with [nodeunit][nodeunit].
* [watch](task_watch.md) - Run predefined tasks whenever watched files change.
-->

[jshint]: http://www.jshint.com/
[uglify]: https://github.com/mishoo/UglifyJS/
[nodeunit]: https://github.com/caolan/nodeunit
[qunit]: http://docs.jquery.com/QUnit
[phantom]: http://www.phantomjs.org/

## Other built-ins <a name="other-built-ins" href="#other-built-ins" title="Link to this section">⚑</a>

* [Helpers and Directives](helpers_directives.md) - Ones not specifically covered in other task documentation.

## Development <a name="development" href="#development" title="Link to this section">⚑</a>

* [Contributing to grunt](contributing.md) - Development advice.

<!-- * [Grunt plugins](plugins.md) - -->
